simple-editor
=============
This is a very simple demo application for OpenShot Cloud API. You can log-in, upload files,
create/edit clips, move clips (up/down), and export, and download a video.

You can also check out the **hosted** version of this app: 
https://cloud.openshot.org/apps/simple-editor/

urls:
-----
  - **/login/**:  User login to API instance (auth saved to localStorage)
  - **/logout/**:  Log out the current user
  - **/projects/**:  List all projects (create, edit, copy, delete)
  - **/projects/ID/**:  Video editor (files, clips, preview, export)

Features:
-------
  - **Files**: upload (w/progress bars), filter, and delete
  - **Clips**: trimming (start, end), position (move clip), edit, delete
  - **Preview**: file & clips supported, play/pause, simple timeline w/ trimming, add-clip button
  - **Export**: progress bar, cancel, download, preview (show last export)

## Source Code
The source code is hosted on OpenShot Studio's GitLab server: 
http://gitlab.openshot.org/public-projects/simple-editor. It is licensed under the MIT license,
and can be used in both open-source and commercial projects.
```
git clone git@gitlab.openshot.org:public-projects/simple-editor.git
```

## Project setup
```
npm install
```

### Compiles and hot-reloads for development
```
npm run serve
```

- 1: Modify `.env.development` file and update the `VUE_APP_OPENSHOT_API_URL` variable used in development mode.
  This is a required step when building this application for use with your own **OpenShot Cloud API** server.
- 2: Modify `vue.config.js` file and update the `publicPath` variable to the path you are serving the app from.
  For example: `/` is the web server root, `/apps/simple-editor` if serving from a sub-folder, etc...

### Compiles and minifies for production
```
npm run build
```

 - 1: Modify `.env.production` file and update the `VUE_APP_OPENSHOT_API_URL` variable used in production/build mode. 
      This is a required step when building this application for use with your own **OpenShot Cloud API** server. 
 - 2: Modify `vue.config.js` file and update the `publicPath` variable to the path you are serving the app from. 
      For example: `/` is the web server root, `/apps/simple-editor` if serving from a sub-folder, etc...

This will generate a `dist` folder, which contains all the needed files to deploy this application. The dist directory 
is meant to be served by an HTTP server, so it will not work if you open dist/index.html directly over file:// protocol.

### Update npm depedencies
```
npm i -g npm-check-updates
ncu -u
npm install
```

### Deploy application to Web Server
If using Apache as your production web server, deploying the `dist` folder 
to your web server requires an extra step. Some URLs used in this app
are not real files served by Apache (i.e. /projects/ID/), and thus, if a user
reloads the web browser, the server will return a 404 error.

To prevent this, any requests for missing resources on your web server should have 
a fallback to `index.html`. For example...
```
    <Directory "/home/ubuntu/api/apps/simple-editor/">
        FallbackResource /apps/simple-editor/index.html
    </Directory>
```

The following **commands** are used to automate the deployment
of this app using **GitLab CI**. You will likely need a similar
script to automate your own deployments of this app.
```
  script:
    - npm ci
    - npm run build
    - mkdir -p /home/ubuntu/api/apps/simple-editor/public/
    - cp -R dist/. /home/ubuntu/api/apps/simple-editor/
    - cp -R public/. /home/ubuntu/api/apps/simple-editor/public/
```
Read more about deployment: https://cli.vuejs.org/guide/deployment.html

### Lints and fixes files
```
npm run lint
```

### Customize configuration
Configuration variables are stored in `.env` and `vue.config.js` files.

- `VUE_APP_GA_ID`: Global site tag (gtag.js) for tracking on Google Analytics
- `VUE_APP_OPENSHOT_API_URL`: URL of your own OpenShot Cloud API instance
- `publicPath`: Relative path where this app will be served by your production web server

See [Configuration Reference](https://cli.vuejs.org/config/).
