import { createApp } from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'
import "bootstrap/dist/css/bootstrap.min.css"
import "bootstrap"
import { createGtag } from "vue-gtag"
import { initAdsConversions, isDemoEnvironment } from "./utils/adsConversions"

const app = createApp(App)

const tagId = process.env.VUE_APP_GA_ID
if (tagId) {
  app.use(createGtag({
    tagId,
    pageTracker: {
      router
    }
  }))
}

initAdsConversions({
  router,
  demoMode: isDemoEnvironment()
})

app.use(store).use(router).mount('#app')
