import { createRouter, createWebHistory } from 'vue-router'
import Home from '../views/Home.vue'

const routes = [
  {
    path: '/',
    name: 'Projects',
    component: Home,
  },
  {
    path: '/projects/:id',
    name: 'Editor',
    component: () => import('../views/Editor.vue'),
    props: true
  },
  {
    path: '/login',
    name: 'Login',
    component: () => import('../views/Login.vue')
  },
  {
    path: '/logout',
    name: 'Logout',
    component: () => import('../views/Logout.vue')
  },
  {
    path: '/about',
    name: 'About',
    component: () => import('../views/About.vue')
  }
]

const router = createRouter({
  history: createWebHistory(process.env.BASE_URL),
  routes,
  linkActiveClass: "active"
})

router.beforeEach((to, from, next) => {
  document.title = `${to.name} | Simple Editor | Demo app for OpenShot Cloud API`;
  next();
});

export default router
