import axios from "axios";


// Init a new axios instance, with auth
const instance = axios.create({
    baseURL: process.env.VUE_APP_OPENSHOT_API_URL,
    headers: {'X-Requested-With': 'XMLHttpRequest'}
});

// Init a new axios instance, with auth
const blob_instance = axios.create({});

// Set the AUTH token for any request
instance.interceptors.request.use(function (config) {
    const token = localStorage.auth
    config.headers.Authorization =  token ? token : '';
    return config;
});

function fixImageDuration(duration) {
    if (duration == 3600) {
        return 30
    } else {
        return duration
    }
}

function reorderArray(array, sourceIndex, destinationIndex) {
    const smallerIndex = Math.min(sourceIndex, destinationIndex)
    const largerIndex = Math.max(sourceIndex, destinationIndex)

    return [
        ...array.slice(0, smallerIndex),
        ...(sourceIndex < destinationIndex
            ? array.slice(smallerIndex + 1, largerIndex + 1)
            : []),
        array[sourceIndex],
        ...(sourceIndex > destinationIndex
            ? array.slice(smallerIndex, largerIndex)
            : []),
        ...array.slice(largerIndex + 1),
    ]
}

export { instance, blob_instance, fixImageDuration, reorderArray };